(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8172,        194]
NotebookOptionsPosition[      7587,        168]
NotebookOutlinePosition[      7980,        185]
CellTagsIndexPosition[      7937,        182]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 ".NET/Link Example: PackageHelper\n\n",
 StyleBox["This example demonstrates creating and running a \"modal\" dialog \
box. It shows:\n\t- a modal dialog using the ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DoNETModal",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" function\n\t- returning a result from a modal dialog\n\t- the use \
of ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["AddEventHandler",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" to wiire up some simple ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" functions for event callbacks\n\nThe program displays a dialog \
box showing a list of all the standard add-on packages that ship with ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[". The ones that are currently loaded are shown with a check mark. \
You can select additional packages by clicking them so that they have a check \
mark as well. The packages you selected are loaded if you click the Load \
button to dismiss the dialog. If you click Cancel, nothing happens. The \
function returns the current value of $Packages, unless it was cancelled, in \
which case it reutrns Null.\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Section"],

Cell[TextData[{
 "Needs[\"NETLink`\"];\nNeeds[\"Utilities`Package`\"];\n\nPackageHelper[] :=\n\
\tNETBlock[\n\t\tModule[{packages, form, listBox, loadButton, cancelButton, \
getCheckedItems, selectedContexts},\n\t\t\n\t\t\t(* This gets the list of all \
contexts for the standard add-on packages. *)\n\t\t\tpackages = \
FindPackages[ToFileName[{$TopDirectory, \"AddOns\", \"StandardPackages\"}]];\n\
\t\t\t\n\t\t\tInstallNET[];\n\t\t\t\n\t\t\t(* Load some classes from which we \
need to call static members. *)\n\t\t\t\
LoadNETType[\"System.Windows.Forms.DialogResult\"];\n\t\t\t\
LoadNETType[\"System.Windows.Forms.FormStartPosition\"];\n\t\t\t\
LoadNETType[\"System.Windows.Forms.FormBorderStyle\"];\n\t\t\t\n\t\t\t(* \
Create the main form and populate it with components. *)\n\t\t\tform = \
NETNew[\"System.Windows.Forms.Form\"];\n\t\t\tform@Text = \"Standard Packages\
\";\n\t\t\tform@Width = 300;\n\t\t\tform@Height = 500;\n\t\t\t\
form@StartPosition = FormStartPosition`CenterScreen;\n\t\t\t\
form@FormBorderStyle = FormBorderStyle`FixedDialog;\n\t\t\tform@MaximizeBox = \
False;\n\t\t\tlistBox = NETNew[\"System.Windows.Forms.CheckedListBox\"];\n\t\t\
\tlistBox@Parent = form;\n\t\t\tlistBox@Bounds = \
NETNew[\"System.Drawing.Rectangle\", 6, 10, 280, 420];\n\t\t\t\
listBox@CheckOnClick = True;\n\t\t\tloadButton = \
NETNew[\"System.Windows.Forms.Button\"];\n\t\t\tcancelButton = \
NETNew[\"System.Windows.Forms.Button\"];\n\t\t\tloadButton@Parent = form;\n\t\
\t\tcancelButton@Parent = form;\n\t\t\tloadButton@Text = \"Load\";\n\t\t\t\
cancelButton@Text = \"Cancel\";\n\t\t\t\n\t\t\t(* These lines populate the \
list box with the package contexts and set their checked/unchecked state. *)\n\
\t\t\tlistBox@Items@AddRange[packages];\n\t\t\t\
MapIndexed[listBox@SetItemChecked[First[#2]-1, MemberQ[$Packages, #1]]&, \
packages];\n",
 StyleBox["\n",
  FontWeight->"Plain"],
 "\t\t\t(* Setting the DialogResult property of these buttons causes them to \
set the parent form's\n\t\t\t   DialogResult property to these values when \
they are clicked. When the dialog closes we\n\t\t\t   can inspect the form's \
DialogResult property to determine which button was clicked to\n\t\t\t   \
close the dialog.\n\t\t\t*)\n\t\t\tloadButton@DialogResult = DialogResult`OK;\
\n\t\t\tcancelButton@DialogResult = DialogResult`Cancel;\n\t\t\t\
loadButton@Location = NETNew[\"System.Drawing.Point\", 20, listBox@Bottom + \
6];\n\t\t\tcancelButton@Location = NETNew[\"System.Drawing.Point\", 195, \
listBox@Bottom + 6];\n\t\t\t\n\t\t\t(* Setting these properties cause the \
buttons to respond to the Return and Esc key, respectively. *)\n\t\t\t\
form@AcceptButton = loadButton;\n\t\t\tform@CancelButton = cancelButton;\n\t\t\
\n\t\t\t(* We still need to wire up handlers to cause the dialog to close \
when the buttons are clicked.\n\t\t\t   That would happen automatically if we \
were to use the ShowDialog() method to run the modal\n\t\t\t   dialog, which \
is the standard .NET technique for modal dialogs. We don't use ShowDialog()\n\
\t\t\t   because it is not guaranteed to make the dialog visible in front of \
the notebook window.\n\t\t\t*)\n\t\t\tAddEventHandler[loadButton@Click, \
form@Close[]&];\n\t\t\tAddEventHandler[cancelButton@Click, form@Close[]&];\n\t\
\t\t\n\t\t\t(* This is the function called when the dialog box is closed to \
get the list of checked contexts.\n\t\t\t   It checks the form's DialogResult \
property to determine whether the form was closed by\n\t\t\t   clicking the \
Load (equivalent to OK) or Cancel button.\n\t\t\t*)\n\t\t\t\
getCheckedItems[f_] := If[f@DialogResult === DialogResult`OK, \
listBox@CheckedItems, Null];\n\t\t\t\n\t\t\t(* Run the dialog modally. The \
second argument to DoNETModal is code that will be called\n\t\t\t   just \
before the form is destroyed, and what it returns will be the return value of \
DoNETModal.\n\t\t\t   DoNETModal will not return until the dialog is \
dismissed.\n\t\t\t*)\n\t\t\tselectedContexts = DoNETModal[form, \
getCheckedItems[form]];\n\t\t\t\n\t\t\tIf[selectedContexts =!= Null,\n\t\t\t\t\
(* selectedContexts is the object returned by the CheckedItems property of \
the list box\n\t\t\t\t   (see the getCheckedItems function defined above). \
This is an object that implements\n\t\t\t\t   the ICollection interface. The \
NETObjectToExpression converts all ICollection\n\t\t\t\t   objects to \
Mathematica lists.\n\t\t\t\t*)\n\t\t\t\tNeeds /@ \
NETObjectToExpression[selectedContexts];\n\t\t\t\t$Packages,\n\t\t\t(* else \
*)\n\t\t\t\tNull\n\t\t\t]\n\t\t]\n\t]"
}], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["PackageHelper[]", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{931, 625},
WindowMargins->{{2, Automatic}, {Automatic, 1}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 2232, 61, 419, "Title"],
Cell[CellGroupData[{
Cell[2847, 88, 23, 0, 67, "Section"],
Cell[2873, 90, 4588, 67, 1577, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[7498, 162, 26, 0, 37, "Section"],
Cell[7527, 164, 32, 0, 24, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

